#include "wthelper.h"

//class directwork : public CWaveEditorDirectWork {
//public:
//	virtual char * AboutImplementation();
//	virtual void WorkStereo(float *psamples, int numsamples);
//};

class helper : public CWTHelper {
public:
	virtual bool __cdecl Init();

	virtual bool __cdecl CanPreview(char * name) { return false; };
	virtual bool __cdecl CanImport(char * name) { return false; };

	virtual bool __cdecl TranslatePathForFile(char * name, char *newname);
	virtual bool __cdecl DoubleClickUseFile(char * name, CWaveBrowserHandler *wbh);
	virtual void __cdecl DoubleClickDisplayFolders(char * name, CWaveBrowserHandler *wbh);
	virtual void __cdecl DoubleClickDisplayFiles(char * name, CWaveBrowserHandler *wbh);

    virtual bool __cdecl Import(char * namex, CWaveBrowserHandler *wbh);
    virtual bool __cdecl Export(float *psamples, int numsamples, char *filename);

	virtual void __cdecl SettingsChanged() { };
	virtual char * __cdecl HelperWebsiteURL() { return "http://www.buzzformat.com/"; };

	virtual void __cdecl GetExtensionsClass(int param, void **exmodule);
	virtual void __cdecl DispatchCommand(int command_id, int param1, int param2, int param3, int param4) { }
	virtual void __cdecl DispatchCommandEx(char * str_command, char * str_value) { }
};

bool helper::Init(){
	return true;
}

bool helper::TranslatePathForFile(char *namex, char *newname) {
	return false;
}

bool helper::DoubleClickUseFile(char *namex, CWaveBrowserHandler *wbh) {
	char extension[4];
	strcpy(extension, &namex[strlen(namex)-4]);
	
	if ((strcmp(strupr(extension), ".WAV") == 0)) {
		char chunk[5];
		char junk[254];
		unsigned long length;
		bool filedone = false;
		unsigned short enctype;
		unsigned short channels;
		unsigned long samplerate;
		unsigned short datathing1;
		int bitdepth=0;
		
		chunk[4] = 0;
		FILE * wavfile = fopen(namex,"rb");
		if (wavfile != NULL) {
			fread(chunk,1,4,wavfile);
			if (strcmp(chunk, "RIFF") == 0) {
				fread(&length,sizeof(long),1,wavfile); // size
				fread(chunk,1,4,wavfile); // should be WAVE
				if (strcmp(chunk, "WAVE") == 0) {
					while (filedone == false) {
						fread(chunk,1,4,wavfile); // now the header things
						fread(&length,sizeof(long),1,wavfile); // length of it
						if (strcmp(chunk, "fmt ") == 0) {
							fread(&enctype,sizeof(short),1,wavfile);
							fread(&channels,sizeof(short),1,wavfile);

							fread(&samplerate,sizeof(long),1,wavfile);
							fread(junk,sizeof(long),1,wavfile);
							fread(&datathing1,sizeof(short),1,wavfile);
							fread(junk,sizeof(short),1,wavfile);
							length -= 16;
							if (length != 0) {
								fread(junk, length, 1, wavfile);
							}
							if (enctype == 1) { // pcm
								if ((datathing1/channels) == 1) {
									// 16 bit PCM
									bitdepth=0;
								} else {
									wbh->CantLoadReason("The windows waveform file can't be understood. The least I know is that it is format category 1 (PCM).", "8 bit loader");
									fclose(wavfile);
									return false;
								}
							} else {
								wbh->CantLoadReason("The windows waveform file can't be understood. The format category is unknown.", "8 bit loader");
								fclose(wavfile);
								return false;
							}
						} else if (strcmp(chunk, "data") == 0) {
							int i = 0;
							int position = wbh->GetWaveEditorPosition();
							if (position == -1) {
								wbh->CantLoadReason("Choose a location in the wavetable first. Do this by clicking on an entry in the numbered list on the left.", "8 bit WTHelper");
								fclose(wavfile);
								return false;
							} 

							if (bitdepth == 0) {
								unsigned char readsamp;
								wbh->WavePlayerReserve();
								float * psamps = wbh->GetWavePlayerBuffer(length/channels*2, samplerate);
								if (channels == 2) { 
									i = 0;
									while (length != 0) {
										fread(&readsamp, sizeof(char), 1, wavfile);
										psamps[i] = (float)((((int)readsamp)-128)* 256);
										length -= 1;
										i++;
									}
								} else {
									i = 0;
									while (length != 0) {
										fread(&readsamp, sizeof(char), 1, wavfile);
										psamps[i] = (float)((((int)readsamp)-128)* 256);
										i++;
										psamps[i] = (float)((((int)readsamp)-128)* 256);
										length -= 1;
										i++;
									}
								}
								wbh->WavePlayerPlay();
							}
							
							filedone = true;
						} else {
							while (length != 0) {
								if (length > 254) {
									fread(junk, 254, 1, wavfile);
									length -= 254;
								} else {
									fread(junk, length, 1, wavfile);
									length = 0;
								}
							}
						}
					}
				} else {
					wbh->CantLoadReason("The windows waveform file does not have the required RIFF header. \"WAVE\" is missing.", "Standard WTHelper");
					fclose(wavfile);
					return false;
				}
			} else {
				wbh->CantLoadReason("The windows waveform file does not have the required RIFF header. \"RIFF\" is missing.", "Standard WTHelper");
				fclose(wavfile);
				return false;
			}
		}
		return true;
	} else {
		return false;
	}
}

void helper::DoubleClickDisplayFolders(char *namex, CWaveBrowserHandler *wbh) {
	// don't need to, the standard already does this
}

void helper::DoubleClickDisplayFiles(char *namex, CWaveBrowserHandler *wbh) {
	// don't need to, the standard already does this
}

// Helper function
void GetNameFromPath(char * name, char * dest) {
	char * nextthing;
	nextthing = strstr(name, "\\");
	if (nextthing != NULL) {
		nextthing=nextthing+1;
		GetNameFromPath(nextthing,dest);
	} else {
		strcpy(dest, name);
	}
}

bool helper::Import(char * namex, CWaveBrowserHandler *wbh) {
	char extension[4];
	char name[256];
	char bufr[256];
	strcpy(extension, &namex[strlen(namex)-4]);
	

	// Creating name suitable for wavetable entry
	sprintf(bufr, namex);
	bufr[strlen(bufr)-4] = 0;
	GetNameFromPath(bufr, name);

	if ((strcmp(strupr(extension), ".WAV") == 0)) {
		char chunk[5];
		char junk[254];
		unsigned long length;
		bool filedone = false;
		unsigned short enctype;
		unsigned short channels;
		unsigned long samplerate;
		unsigned short datathing1;
		int bitdepth=0;
		
		chunk[4] = 0;
		FILE * wavfile = fopen(namex,"rb");
		if (wavfile != NULL) {
			fread(chunk,1,4,wavfile);
			if (strcmp(chunk, "RIFF") == 0) {
				fread(&length,sizeof(long),1,wavfile); // size
				fread(chunk,1,4,wavfile); // should be WAVE
				if (strcmp(chunk, "WAVE") == 0) {
					while (filedone == false) {
						fread(chunk,1,4,wavfile); // now the header things
						fread(&length,sizeof(long),1,wavfile); // length of it
						if (strcmp(chunk, "fmt ") == 0) {
							fread(&enctype,sizeof(short),1,wavfile);
							fread(&channels,sizeof(short),1,wavfile);

							fread(&samplerate,sizeof(long),1,wavfile);
							fread(junk,sizeof(long),1,wavfile);
							fread(&datathing1,sizeof(short),1,wavfile);
							fread(junk,sizeof(short),1,wavfile);
							length -= 16;
							if (length != 0) {
								fread(junk, length, 1, wavfile);
							}
							if (enctype == 1) { // pcm
								if ((datathing1/channels) == 1) {
									// 16 bit PCM
									bitdepth=0;
								} else {
									wbh->CantLoadReason("The windows waveform file can't be understood. The least I know is that it is format category 1 (PCM).", "8 bit loader");
									fclose(wavfile);
									return false;
								}
							} else {
								wbh->CantLoadReason("The windows waveform file can't be understood. The format category is unknown.", "8 bit loader");
								fclose(wavfile);
								return false;
							}
						} else if (strcmp(chunk, "data") == 0) {
							int i = 0;
							int position = wbh->GetWaveEditorPosition();
							if (position == -1) {
								wbh->CantLoadReason("Choose a location in the wavetable first. Do this by clicking on an entry in the numbered list on the left.", "8 bit loader");
								fclose(wavfile);
								return false;
							} 

							if (bitdepth == 0) {
								unsigned char readsamp;
								wbh->GetWaveEditorClass()->CreateSpecificEntry(position,length,namex);
								wbh->GetWaveEditorClass()->SetSampleName(position, name);
								if (channels == 2) { wbh->GetWaveEditorClass()->SetNumChannels(position, (int)channels); }
								wbh->GetWaveEditorClass()->SetSamplerate(position, 0, samplerate);
								wbh->GetWaveEditorClass()->SetLooped (position, false);
								
								short * psamps = wbh->GetWaveEditorClass()->GetSamples(position, 0);
								i = 0;
								while (length != 0) {
									fread(&readsamp, sizeof(char), 1, wavfile);
									psamps[i] = (((int)readsamp)-128)*256;
									length--;
									i++;
								}

							}
							
							filedone = true;
						} else {
							while (length != 0) {
								if (length > 254) {
									fread(junk, 254, 1, wavfile);
									length -= 254;
								} else {
									fread(junk, length, 1, wavfile);
									length = 0;
								}
							}
						}
					}
				} else {
					wbh->CantLoadReason("The windows waveform file does not have the required RIFF header. \"WAVE\" is missing.", "Standard WTHelper");
					fclose(wavfile);
					return false;
				}
			} else {
				wbh->CantLoadReason("The windows waveform file does not have the required RIFF header. \"RIFF\" is missing.", "Standard WTHelper");
				fclose(wavfile);
				return false;
			}
		}
		return true;
	} else {
		return false;
	}
}

bool helper::Export(float *psamples, int numsamples, char *filename) {
	return false;
}

void helper::GetExtensionsClass(int param, void **exmodule) {
//	if (GEC_DIRECTWORK) {
//		*exmodule = &mydirectwork;
//	}
}

EXPORTTHING
